/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.rei.renderer;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.infrastructure.component.BottleType;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_9334;
import net.minecraft.class_9335;

@Environment(value=EnvType.CLIENT)
public record FluidStackRenderer(EntryRenderer<FluidStack> origin) implements EntryRenderer<FluidStack>
{
    public void render(EntryStack<FluidStack> entry, class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        FluidStack stack = (FluidStack)entry.getValue();
        class_3611 fluid = stack.getFluid();
        FluidConfig config = AllFluidConfigs.get(fluid);
        if (config == null) {
            return;
        }
        int color = config.tint().apply(stack.getComponents().method_57940()) | 0xFF000000;
        graphics.method_52710(class_10799.field_56883, config.still().get(), bounds.x, bounds.y, bounds.width, bounds.height, color);
    }

    public Tooltip getTooltip(EntryStack<FluidStack> entry, TooltipContext context) {
        FluidStack stack;
        Tooltip tooltip = this.origin.getTooltip(entry, context);
        if (tooltip == null) {
            return null;
        }
        List entries = tooltip.entries();
        Tooltip.Entry first = (Tooltip.Entry)entries.getFirst();
        if (first.isText() && (stack = (FluidStack)entry.getValue()).getFluid() == AllFluids.POTION) {
            class_9335 components = stack.getComponents();
            class_1844 contents = (class_1844)components.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
            BottleType bottleType = (BottleType)((Object)components.method_58695(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, (Object)BottleType.REGULAR));
            class_2561 name = contents.method_64195(PotionFluidHandler.itemFromBottleType(bottleType).method_7876() + ".effect.");
            ArrayList<Tooltip.Entry> list = new ArrayList<Tooltip.Entry>();
            list.add(Tooltip.entry((class_2561)name));
            Float scale = (Float)components.method_58694(class_9334.field_55879);
            if (scale == null) {
                scale = bottleType == BottleType.LINGERING ? (Float)class_1802.field_8150.method_57347().method_58695(class_9334.field_55879, (Object)Float.valueOf(1.0f)) : Float.valueOf(1.0f);
            }
            class_1844.method_8065((Iterable)contents.method_57397(), text -> list.add(Tooltip.entry((class_2561)text)), (float)scale.floatValue(), (float)context.vanillaContext().method_59531());
            entries.removeFirst();
            entries.addAll(0, list);
        }
        return tooltip;
    }
}

